using System;
using System.Collections.Generic;

class BankasKonts
{
    private static int nākamaisKontsNumurs = 1000;
    private int kontaNumurs;
    private string kontaĪpašnieks;
    private decimal atlikums;

    public BankasKonts(string kontaĪpašnieks, decimal sākumaAtlikums)
    {
        this.kontaNumurs = nākamaisKontsNumurs++;
        this.kontaĪpašnieks = kontaĪpašnieks;
        this.atlikums = sākumaAtlikums;
        Console.WriteLine($"Konts izveidots! Konta numurs: {kontaNumurs}\n");
    }

    ~BankasKonts()
    {
        Console.WriteLine($"Konts {kontaNumurs} tiek iznīcināts.");
    }

    public int IegūtKontaNumuru() => kontaNumurs;

    public void Noguldīt(decimal summa)
    {
        if (summa <= 0)
            throw new ArgumentException("Noguldījuma summai jābūt pozitīvai.");
        atlikums += summa;
        Console.WriteLine($"Noguldīti {summa} EUR kontā {kontaNumurs}.\n");
    }

    public void Izņemt(decimal summa)
    {
        if (summa <= 0)
            throw new ArgumentException("Izņemamajai summai jābūt pozitīvai.");
        if (summa > atlikums)
            throw new InvalidOperationException("Nepietiekams atlikums kontā.");
        atlikums -= summa;
        Console.WriteLine($"Izņemti {summa} EUR no konta {kontaNumurs}.\n");
    }

    public void ParādītInformāciju()
    {
        Console.WriteLine($"Konts: {kontaNumurs}\nĪpašnieks: {kontaĪpašnieks}\nAtlikums: {atlikums} EUR\n");
    }
}

class Programma
{
    static List<BankasKonts> konti = new List<BankasKonts>();

    static void Main()
    {
        while (true)
        {
            Console.WriteLine("=== Bankas kontu pārvaldības sistēma ===");
            Console.WriteLine("1. Izveidot jaunu kontu");
            Console.WriteLine("2. Noguldīt naudu");
            Console.WriteLine("3. Izņemt naudu");
            Console.WriteLine("4. Parādīt konta informāciju");
            Console.WriteLine("5. Iziet\n");
            Console.Write("Jūsu izvēle: ");

            string izvēle = Console.ReadLine();
            Console.WriteLine();

            try
            {
                switch (izvēle)
                {
                    case "1":
                        IzveidotKontu();
                        break;
                    case "2":
                        VeiktNoguldījumu();
                        break;
                    case "3":
                        VeiktIzņemšanu();
                        break;
                    case "4":
                        ParādītInformāciju();
                        break;
                    case "5":
                        return;
                    default:
                        Console.WriteLine("Nederīga izvēle!\n");
                        break;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"Kļūda: {ex.Message}\n");
            }
        }
    }

    static void IzveidotKontu()
    {
        Console.Write("Ievadiet konta īpašnieka vārdu: ");
        string vārds = Console.ReadLine();

        Console.Write("Ievadiet sākotnējo atlikumu: ");
        decimal atlikums = decimal.Parse(Console.ReadLine());

        BankasKonts konts = new BankasKonts(vārds, atlikums);
        konti.Add(konts);
    }

    static BankasKonts AtrastKontu()
    {
        Console.Write("Ievadiet konta numuru: ");
        int numurs = int.Parse(Console.ReadLine());
        foreach (var konts in konti)
        {
            if (konts.IegūtKontaNumuru() == numurs)
                return konts;
        }
        throw new Exception("Konts netika atrasts.");
    }

    static void VeiktNoguldījumu()
    {
        var konts = AtrastKontu();
        Console.Write("Ievadiet noguldāmo summu: ");
        decimal summa = decimal.Parse(Console.ReadLine());
        konts.Noguldīt(summa);
    }

    static void VeiktIzņemšanu()
    {
        var konts = AtrastKontu();
        Console.Write("Ievadiet izņemamo summu: ");
        decimal summa = decimal.Parse(Console.ReadLine());
        konts.Izņemt(summa);
    }

    static void ParādītInformāciju()
    {
        var konts = AtrastKontu();
        konts.ParādītInformāciju();
    }
}